(*----------------------------------------------------------------------------*)
(* Joachim Pimiskern, 2004. Freeware.                                         *)
(* Use and/or modify it at your own risk. I'd appreciate if you left a        *)
(* comment in the source files about the original author.                     *)
(*----------------------------------------------------------------------------*)
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Edit1: TEdit;
    Button1: TButton;
    OpenDialog1: TOpenDialog;
    Memo1: TMemo;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    Button10: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
  private
    procedure GetTagUntilEndTag(tag_string: string);
    procedure GetMetaTag(name: string);
    procedure OnTranslateVariable(var Variable: string);
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation
uses
   martok, htmlparts;

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  opendialog1.InitialDir := extractfilepath(application.exename);
  if opendialog1.execute then
     edit1.text := opendialog1.filename;
end;

procedure TForm1.GetTagUntilEndTag(tag_string: string);
var cs: TCharStream;
    m : TMarkupTokenizer;
    tp: TTagParser;
    hp: THtmlParts;
begin
  Memo1.clear;

  cs := TCharStream.Create(Edit1.Text);
  try
    m := TMarkupTokenizer.Create(cs);
    try
      tp := TTagParser.Create(m);
      try
        hp := THtmlParts.Create(tp);
        try
          Memo1.Lines.Add(hp.GetRange(tag_string));
        finally
          hp.Free;
        end;
      finally
        tp.Free;
      end;
    finally
      m.Free;
    end;
  finally
    cs.Free;
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
var cs: TCharStream;
    fw: TFileWithVariables;
begin
  cs := TCharStream.Create(Edit1.Text);
  try
    fw := TFileWithVariables.Create(cs);
    try
      fw.OnTranslateVariable := OnTranslateVariable;
      Memo1.Lines.Text := fw.Expand;
    finally
      fw.Free;
    end;
  finally
    cs.Free;
  end;
end;


procedure TForm1.OnTranslateVariable(var Variable: string);
begin
  if (Variable = '$firstVariable') then
     Variable := '<h1>First Variable</h1>';
  if (Variable = '$secondVariable') then
     Variable := '<h2>Second Variable</h2>';
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  GetTagUntilEndTag('head');
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  GetTagUntilEndTag('body');
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  GetTagUntilEndTag('title');
end;

procedure TForm1.Button6Click(Sender: TObject);
var cs: TCharStream;
    m : TMarkupTokenizer;
    tp: TTagParser;
    hp: THtmlParts;
begin
  Memo1.clear;

  cs := TCharStream.Create(Edit1.Text);
  try
    m := TMarkupTokenizer.Create(cs);
    try
      tp := TTagParser.Create(m);
      try
        hp := THtmlParts.Create(tp);
        try
          Memo1.Lines.Add(hp.GetMetaTags());
        finally
          hp.Free;
        end;
      finally
        tp.Free;
      end;
    finally
      m.Free;
    end;
  finally
    cs.Free;
  end;
end;






procedure TForm1.GetMetaTag(name: string);
var cs: TCharStream;
    m : TMarkupTokenizer;
    tp: TTagParser;
    hp: THtmlParts;
begin
  Memo1.clear;

  cs := TCharStream.Create(Edit1.Text);
  try
    m := TMarkupTokenizer.Create(cs);
    try
      tp := TTagParser.Create(m);
      try
        hp := THtmlParts.Create(tp);
        try
          Memo1.Lines.Add(hp.GetMetaTag(name));
        finally
          hp.Free;
        end;
      finally
        tp.Free;
      end;
    finally
      m.Free;
    end;
  finally
    cs.Free;
  end;
end;












procedure TForm1.Button7Click(Sender: TObject);
begin
  GetMetaTag('description');
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
  GetMetaTag('keywords');
end;

procedure TForm1.Button9Click(Sender: TObject);
begin
  Memo1.Lines.LoadFromFile(Edit1.Text);
end;

procedure TForm1.Button10Click(Sender: TObject);
var cs: TCharStream;
    m : TMarkupTokenizer;
    tp: TTagParser;
    hp: THtmlParts;
    Links: TStringList;
begin
  Memo1.clear;

  cs := TCharStream.Create(Edit1.Text);
  try
    m := TMarkupTokenizer.Create(cs);
    try
      tp := TTagParser.Create(m);
      try
        hp := THtmlParts.Create(tp);
        try
          Links := hp.GetLinks();
          Memo1.Lines.Assign(Links);
          Links.Free;
        finally
          hp.Free;
        end;
      finally
        tp.Free;
      end;
    finally
      m.Free;
    end;
  finally
    cs.Free;
  end;
end;


end.
