(*----------------------------------------------------------------------------*)
(* Joachim Pimiskern, 2004. Freeware.                                         *)
(* Use and/or modify it at your own risk. I'd appreciate if you left a        *)
(* comment about the original author in the source files.                     *)
(*----------------------------------------------------------------------------*)
unit htmlparts;

interface
uses
  classes,
  martok;

type
  THtmlParts = class
    FTagParser: TTagParser;
    constructor Create(TagParser: TTagParser);
    destructor  Destroy; override;
    function    GetMetaTags: string;
    function    GetMetaTag(Name: string): string;
    function    GetRange(Name: string): string;
    function    GetRangeWithoutBounds(Name: string): string;
    function    GetLinks: TStringList;
  end;


  TTranslateVariableEvent = procedure(var Variable: string) of object;

  TFileWithVariables = class
    FCharStream: TCharStream;
    FOnTranslateVariable: TTranslateVariableEvent;
    constructor Create(CharStream: TCharStream);
    destructor  Destroy; override;
    function    Expand: string;
    property    OnTranslateVariable: TTranslateVariableEvent read FOnTranslateVariable write FOnTranslateVariable;
  end;

implementation
uses
  sysutils;

constructor THtmlParts.Create(TagParser: TTagParser);
begin
  inherited Create;
  FTagParser := TagParser;
end;

destructor THtmlParts.Destroy;
begin
  inherited Destroy;
end;


function THtmlParts.GetMetaTags: string;
var i      : integer;
    ttt    : TTagToken;
    tagname: string;
    sl     : TStringList;
begin
  result := '';
  sl := TStringList.Create;
  try
    for i := 0 to FTagParser.Tokens.Count - 1 do
        begin
          ttt := FTagParser.Tokens[i];
          if (ttt.TokenType = ttt_tag) then
             begin
               tagname := ttt.Data.Get('tagname');
               if (tagname = 'meta') then
                  sl.add(ttt.Data.Get('originaltext'));
             end;
        end;
    result := sl.Text;
  finally
    sl.Free;
  end;
end;


function THtmlParts.GetMetaTag(Name: string): string;
var i      : integer;
    ttt    : TTagToken;
    tagname: string;
    tname  : string;
begin
  result := '';
  for i := 0 to FTagParser.Tokens.Count - 1 do
      begin
        ttt := FTagParser.Tokens[i];
        if (ttt.TokenType = ttt_tag) then
           begin
             tagname := ttt.Data.Get('tagname');
             if (
                 (tagname = 'meta') and
                 (ttt.Data.Exists('name'))
                ) then
                begin
                  tname := ttt.Data.Get('name');
                  if (
                      (tname = Lowercase(Name)) and
                      (ttt.Data.Exists('content'))
                     ) then
                     result := ttt.Data.Get('content');
                end;
           end;
      end;
end;


function THtmlParts.GetRange(Name: string): string;
var sl   : TStringList;
    state: integer;
    i    : integer;
    ttt    : TTagToken;
    tagname: string;
    tagtype: string;
begin
  result := '';
  sl := TStringList.Create;
  try
    state := 0;
    for i := 0 to FTagParser.Tokens.Count - 1 do
        begin
          ttt := FTagParser.Tokens[i];
          if (ttt.TokenType = ttt_tag) then
             begin
               if (
                   (ttt.Data.Exists('tagname')) and
                   (ttt.Data.Exists('tagtype'))
                  ) then
                  begin
                    tagname := ttt.Data.Get('tagname');
                    tagtype := ttt.Data.Get('tagtype');
                    if (
                        (tagname = lowercase(Name)) and
                        (tagtype = 'begin')
                       ) then
                       state := 1;

                    if (state = 1) then
                       result := result + ttt.Data.Get('originaltext');

                    if (
                        (tagname = lowercase(Name)) and
                        (tagtype = 'end')
                       ) then
                       state := 0;
                  end;
             end
          else
          if (
              (ttt.TokenType = ttt_anytext) and
              (state = 1)
             ) then
             result := result + ttt.TokenString;
        end;
  finally
    sl.Free;
  end;
end;



function THtmlParts.GetRangeWithoutBounds(Name: string): string;
var sl   : TStringList;
    state: integer;
    i    : integer;
    ttt    : TTagToken;
    tagname: string;
    tagtype: string;
begin
  result := '';
  sl := TStringList.Create;
  try
    state := 0;
    for i := 0 to FTagParser.Tokens.Count - 1 do
        begin
          ttt := FTagParser.Tokens[i];
          if (ttt.TokenType = ttt_tag) then
             begin
               if (
                   (ttt.Data.Exists('tagname')) and
                   (ttt.Data.Exists('tagtype'))
                  ) then
                  begin
                    tagname := ttt.Data.Get('tagname');
                    tagtype := ttt.Data.Get('tagtype');
                    if (
                        (tagname = lowercase(Name)) and
                        (tagtype = 'begin')
                       ) then
                       state := 1
                    else
                    if (
                        (tagname = lowercase(Name)) and
                        (tagtype = 'end')
                       ) then
                       state := 0
                    else
                    if (state = 1) then
                       result := result + ttt.Data.Get('originaltext');

                  end;
             end
          else
          if (
              (ttt.TokenType = ttt_anytext) and
              (state = 1)
             ) then
             result := result + ttt.TokenString;
        end;
  finally
    sl.Free;
  end;
end;



function THtmlParts.GetLinks: TStringList;
var i      : integer;
    ttt    : TTagToken;
    tagname: string;
begin
  result := TStringList.Create;

  for i := 0 to FTagParser.Tokens.Count - 1 do
      begin
        ttt := FTagParser.Tokens[i];
        if (ttt.TokenType = ttt_tag) then
           try
             tagname := ttt.Data.Get('tagname');
             if (tagname = 'a') then
                result.add(ttt.Data.Get('href'));
           except  
           end;
      end;
end;








(*----------------------------------------------------------------------------*)

constructor TFileWithVariables.Create(CharStream: TCharStream);
begin
  inherited Create;
  FCharStream := CharStream;
end;

destructor  TFileWithVariables.Destroy;
begin
  inherited Destroy;
end;

function TFileWithVariables.Expand: string;
var potentialVariable: string;
    c,state: integer;
begin
  result := '';
  potentialVariable := '';

  state := 0;
  c := FCharStream.NextChar;
  while (c >= 0) do
  begin
    if (state = 0) then
       begin
         if (chr(c) = '$') then
            begin
              potentialVariable := potentialVariable + chr(c);
              state := 100;
            end
         else
            begin
              result := result + chr(c);
              state := 0;
            end;
       end
    else
    if (state = 100) then
       begin
         if (
             ((chr(c) >= '0') and (chr(c) <= '9')) or
             ((chr(c) >= 'a') and (chr(c) <= 'z')) or
             ((chr(c) >= 'A') and (chr(c) <= 'Z')) or
             (chr(c) = '_')
            ) then
            begin
              potentialVariable := potentialVariable + chr(c);
              state := 100;
            end
         else
            begin
              if (length(potentialVariable) >= 2) then
                 FOnTranslateVariable(potentialVariable);
              result := result + potentialVariable + chr(c);
              potentialVariable := '';
              state := 0;
            end;
       end;
    c := FCharStream.NextChar;
  end;

  if (length(potentialVariable) >= 2) then
     begin
       FOnTranslateVariable(potentialVariable);
       result := result + potentialVariable;
     end;
end;


end.
