(*----------------------------------------------------------------------------*)
(* Joachim Pimiskern, 2004. Freeware.                                         *)
(*----------------------------------------------------------------------------*)
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Edit1: TEdit;
    ButtonBrowse: TButton;
    OpenDialog1: TOpenDialog;
    Memo1: TMemo;
    ButtonTagTokens: TButton;
    ButtonCharTokens: TButton;
    procedure ButtonBrowseClick(Sender: TObject);
    procedure ButtonTagTokensClick(Sender: TObject);
    procedure ButtonCharTokensClick(Sender: TObject);
  private
  public
  end;

var
  Form1: TForm1;

implementation
uses
   martok, htmlparts;

{$R *.DFM}

procedure TForm1.ButtonBrowseClick(Sender: TObject);
begin
  opendialog1.InitialDir := extractfilepath(application.exename);
  if opendialog1.execute then
     edit1.text := opendialog1.filename;
end;


procedure TForm1.ButtonTagTokensClick(Sender: TObject);
var cs : TCharStream;
    m  : TMarkupTokenizer;
    tp : TTagParser;
    i  : integer;
    ttt: TTagToken;
begin
  Memo1.clear;

  cs := TCharStream.Create(Edit1.Text);
  try
    m := TMarkupTokenizer.Create(cs);
    try
      tp := TTagParser.Create(m);
      try
        for i := 0 to tp.FTokens.Count - 1 do
        begin
          ttt := tp.FTokens[i];
          Memo1.Lines.Add(ttt.toString());
          Memo1.Lines.Add('');
        end;
      finally
        tp.Free;
      end;
    finally
      m.Free;
    end;
  finally
    cs.Free;
  end;
end;



procedure TForm1.ButtonCharTokensClick(Sender: TObject);
var cs : TCharStream;
    m  : TMarkupTokenizer;
begin
  Memo1.clear;

  cs := TCharStream.Create(Edit1.Text);
  try
    m := TMarkupTokenizer.Create(cs);
    try
      while (m.TokenType <> tt_eof) do
      begin
        Memo1.Lines.Add(m.TokenToString + ':');
        Memo1.Lines.Add(m.TokenString);
        Memo1.Lines.Add('');
        m.nextToken;
      end;
    finally
      m.Free;
    end;
  finally
    cs.Free;
  end;
end;


end.
